/*
 * Decompiled with CFR 0.152.
 */
package com.ribetec.sdk.escpos;

import com.ribetec.sdk.image.PixelImage;
import com.ribetec.sdk.zpl.Zpl;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ESCPos
extends DataOutputStream {
    public static final byte ESC = 27;
    public static final byte GS = 29;
    public static final byte[] LF = new byte[]{10};

    public ESCPos(OutputStream output) {
        super(output);
    }

    public ESCPos init() throws IOException {
        this.write(new byte[]{27, 64});
        return this;
    }

    public ESCPos setUnderline(Underline val) throws IOException {
        this.write(new byte[]{27, 45, val.value});
        return this;
    }

    public ESCPos setBold(boolean bool) throws IOException {
        byte val = (byte)(bool ? 1 : 0);
        this.write(new byte[]{27, 69, val});
        return this;
    }

    public ESCPos setDoubleStrike(boolean bool) throws IOException {
        byte val = (byte)(bool ? 1 : 0);
        this.write(new byte[]{27, 71, val});
        return this;
    }

    public ESCPos setAlignment(Alignment val) throws IOException {
        this.write(new byte[]{27, 97, val.value});
        return this;
    }

    public ESCPos setInverse(boolean bool) throws IOException {
        byte val = (byte)(bool ? 1 : 0);
        this.write(new byte[]{29, 66, val});
        return this;
    }

    public ESCPos setLineSpacing(byte spacing) throws IOException {
        this.write(new byte[]{27, 51, spacing});
        return this;
    }

    public ESCPos feed(int feed) throws IOException {
        this.write(new byte[]{27, 100, (byte)feed});
        return this;
    }

    public ESCPos setAbsolutePrintPosition(int position) throws IOException {
        byte a = (byte)(position % 256);
        byte b = (byte)(position / 256);
        this.write(new byte[]{27, 36, a, b});
        return this;
    }

    public ESCPos setPrintArea(int x, int y, int width, int height) throws IOException {
        byte x1 = (byte)(x % 256);
        byte x2 = (byte)(x / 256);
        byte y1 = (byte)(y % 256);
        byte y2 = (byte)(y / 256);
        byte w1 = (byte)(width % 256);
        byte w2 = (byte)(width / 256);
        byte h1 = (byte)(height % 256);
        byte h2 = (byte)(height / 256);
        this.write(new byte[]{29, 87, x1, x2, y1, y2, w1, w2, h1, h2});
        return this;
    }

    public ESCPos setTextFont(TextFont font) throws IOException {
        this.write(new byte[]{29, 77, font.value});
        return this;
    }

    public ESCPos setCharSize(int val) throws IOException {
        this.write(new byte[]{29, 33, (byte)val});
        return this;
    }

    public ESCPos setCharSize(int widthMultiplier, int heightMultiplier) throws IOException {
        int c = 16 * (widthMultiplier - 1) + (heightMultiplier - 1);
        return this.setCharSize(c);
    }

    public ESCPos setFontSize(int fontWidth, int fontHeight) throws IOException {
        int n = fontWidth << 4 | fontHeight;
        this.write(new byte[]{29, 33, (byte)n});
        return this;
    }

    public ESCPos setCharcode(Charcode val) throws IOException {
        this.write(new byte[]{27, 116, val.value});
        return this;
    }

    public ESCPos utf8() throws IOException {
        return this.setCharcode(Charcode.PC1252);
    }

    public ESCPos println() throws IOException {
        this.write(LF);
        return this;
    }

    public ESCPos println(String txt) throws IOException {
        this.print(txt).println();
        return this;
    }

    public ESCPos print(String txt) throws IOException {
        this.write(txt.getBytes("UTF-8"));
        return this;
    }

    public ESCPos printf(String format, Object ... vars) throws IOException {
        return this.print(String.format(format, vars));
    }

    public ESCPos printfln(String format, Object ... vars) throws IOException {
        return this.println(String.format(format, vars));
    }

    public ESCPos beep() throws IOException {
        this.write(new byte[]{27, 40, 65, 4, 0, 48, 55, 3, 15});
        return this;
    }

    public ESCPos cut() throws IOException {
        this.write(new byte[]{29, 86, 48});
        return this;
    }

    public ESCPos qrcode(String data, QRCodeModel model, int size, QRErrorCorrectionLevel errorCorrection) throws IOException {
        this.write(new byte[]{29, 40, 107, 4, 0, 49, 65, model.value, 0});
        this.write(new byte[]{29, 40, 107, 3, 0, 49, 67, (byte)size});
        this.write(new byte[]{29, 40, 107, 3, 0, 49, 69, errorCorrection.value});
        byte n1 = (byte)((data.length() + 3) % 256);
        byte n2 = (byte)((data.length() + 3) / 256);
        this.write(new byte[]{29, 40, 107, n1, n2, 49, 80, 48});
        this.write(data.getBytes("UTF-8"));
        this.write(new byte[]{29, 40, 107, 3, 0, 49, 81, 48});
        return this;
    }

    public ESCPos qrcode(String data) throws IOException {
        return this.qrcode(data, QRCodeModel._2, 4, QRErrorCorrectionLevel.M);
    }

    public ESCPos barcode(String code, BarcodeType type, int h, int w, BarcodeFont font, BarcodeTxt pos) throws IOException {
        this.write(new byte[]{29, 104, (byte)h});
        this.write(new byte[]{29, 119, (byte)w});
        this.write(new byte[]{29, 72, pos.value});
        this.write(new byte[]{29, 102, font.value});
        this.write(new byte[]{29, 107, type.value});
        if (type.value <= 6) {
            this.write(code.getBytes("UTF-8"));
            this.write(0);
        } else {
            this.write(code.length());
            this.write(code.getBytes("UTF-8"));
        }
        return this;
    }

    public ESCPos barcode(String code, BarcodeType type, int h, int w) throws IOException {
        return this.barcode(code, type, h, w, BarcodeFont.A, BarcodeTxt.BLW);
    }

    public ESCPos psdCode(String data, int type, int h, int w, int cols, int rows, int error) throws IOException {
        this.write(29);
        this.write(40);
        this.write(107);
        this.write(3);
        this.write(0);
        this.write(48);
        this.write(65);
        this.write(cols);
        this.write(29);
        this.write(40);
        this.write(107);
        this.write(3);
        this.write(0);
        this.write(48);
        this.write(66);
        this.write(rows);
        this.write(29);
        this.write(40);
        this.write(107);
        this.write(3);
        this.write(0);
        this.write(48);
        this.write(67);
        this.write(w);
        this.write(29);
        this.write(40);
        this.write(107);
        this.write(3);
        this.write(0);
        this.write(48);
        this.write(68);
        this.write(h);
        this.write(29);
        this.write(40);
        this.write(107);
        this.write(4);
        this.write(0);
        this.write(48);
        this.write(69);
        this.write(48);
        this.write(error);
        this.write(29);
        this.write(40);
        this.write(107);
        this.write(3);
        this.write(0);
        this.write(48);
        this.write(70);
        this.write(type);
        int numberOfBytes = data.length() + 3;
        int pL = numberOfBytes & 0xFF;
        int pH = (numberOfBytes & 0xFF00) >> 8;
        this.write(29);
        this.write(40);
        this.write(107);
        this.write(pL);
        this.write(pH);
        this.write(48);
        this.write(80);
        this.write(48);
        this.write(data.getBytes("UTF-8"));
        this.write(29);
        this.write(40);
        this.write(107);
        this.write(3);
        this.write(0);
        this.write(48);
        this.write(81);
        this.write(48);
        return this;
    }

    public ESCPos psdCode(String code) throws IOException {
        return this.psdCode(code, 0, 4, 3, 0, 0, 49);
    }

    public ESCPos image(PixelImage image, Alignment alignment) throws IOException {
        this.setAlignment(alignment);
        this.write(29);
        this.write(118);
        this.write(48);
        this.write(0);
        int horizontalBytes = image.getHorizontalBytesOfRaster();
        int xL = horizontalBytes & 0xFF;
        int xH = (horizontalBytes & 0xFF00) >> 8;
        int verticalBits = image.getHeight();
        int yL = verticalBits & 0xFF;
        int yH = (verticalBits & 0xFF00) >> 8;
        this.write(xL);
        this.write(xH);
        this.write(yL);
        this.write(yH);
        byte[] rasterBytes = image.getRasterBytes();
        this.write(rasterBytes, 0, rasterBytes.length);
        return this;
    }

    public static String toPrintableString(String escPos) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < escPos.length(); ++i) {
            char c = escPos.charAt(i);
            if (!ESCPos.isPrintableChar(c)) {
                sb.append("\\").append(Zpl.asciiToHex(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static boolean isPrintableChar(char c) {
        Character.UnicodeBlock block = Character.UnicodeBlock.of(c);
        return !Character.isISOControl(c) && block != null && block != Character.UnicodeBlock.SPECIALS;
    }

    public static enum BarcodeTxt {
        OFF(0),
        ABV(1),
        BLW(2),
        BTH(3);

        public byte value;

        private BarcodeTxt(int b) {
            this.value = (byte)b;
        }
    }

    public static enum BarcodeFont {
        A(0),
        B(1);

        public byte value;

        private BarcodeFont(int b) {
            this.value = (byte)b;
        }
    }

    public static enum BarcodeType {
        UPCA(65),
        UPCE(66),
        EAN13(67),
        EAN8(68),
        CODE39(69),
        ITF(70),
        CODABAR(71),
        CODE93(72),
        CODE128(73);

        public byte value;

        private BarcodeType(int b) {
            this.value = (byte)b;
        }
    }

    public static enum QRErrorCorrectionLevel {
        L(48),
        M(49),
        Q(50),
        H(51);

        public byte value;

        private QRErrorCorrectionLevel(int b) {
            this.value = (byte)b;
        }
    }

    public static enum QRCodeModel {
        _1(49),
        _2(50);

        public byte value;

        private QRCodeModel(int b) {
            this.value = (byte)b;
        }
    }

    public static enum Charcode {
        PC437(0),
        JIS(1),
        PC850(2),
        PC860(3),
        PC863(4),
        PC865(5),
        WEU(6),
        GREEK(7),
        HEBREW(8),
        PC1252(16),
        PC866(18),
        PC852(19),
        PC858(20),
        THAI42(21),
        THAI11(22),
        THAI13(23),
        THAI14(24),
        THAI16(25),
        THAI17(26),
        THAI18(27);

        public byte value;

        private Charcode(int b) {
            this.value = (byte)b;
        }
    }

    public static enum Alignment {
        LEFT(0),
        CENTER(1),
        RIGHT(2);

        public byte value;

        private Alignment(int b) {
            this.value = (byte)b;
        }
    }

    public static enum Underline {
        DEFAULT(0),
        SINGLE(1),
        DOUBLE(2);

        public byte value;

        private Underline(int b) {
            this.value = (byte)b;
        }
    }

    public static enum TextFont {
        A(72),
        B(1);

        public byte value;

        private TextFont(int b) {
            this.value = (byte)b;
        }
    }
}

