/*
 * Decompiled with CFR 0.152.
 */
package com.ribetec.sdk.image;

import com.ribetec.sdk.image.Pixel;
import com.ribetec.sdk.image.PixelImage;
import com.ribetec.sdk.image.Transform;

public final class Dither
implements Transform {
    @Override
    public PixelImage apply(PixelImage img) {
        int x;
        int y;
        int w = img.getWidth();
        int h = img.getHeight();
        Pixel[][] d = new Pixel[h][w];
        for (y = 0; y < h; ++y) {
            for (x = 0; x < w; ++x) {
                d[y][x] = new Pixel(img.getPixel(x, y));
            }
        }
        for (y = 0; y < img.getHeight(); ++y) {
            for (x = 0; x < img.getWidth(); ++x) {
                Pixel oldColor = d[y][x];
                Pixel newColor = Pixel.findClosestPaletteColor(oldColor, Pixel.palette);
                img.setPixel(x, y, newColor.toRGB());
                Pixel err = oldColor.sub(newColor);
                if (x + 1 < w) {
                    d[y][x + 1] = d[y][x + 1].add(err.mul(0.4375));
                }
                if (x - 1 >= 0 && y + 1 < h) {
                    d[y + 1][x - 1] = d[y + 1][x - 1].add(err.mul(0.1875));
                }
                if (y + 1 < h) {
                    d[y + 1][x] = d[y + 1][x].add(err.mul(0.3125));
                }
                if (x + 1 >= w || y + 1 >= h) continue;
                d[y + 1][x + 1] = d[y + 1][x + 1].add(err.mul(0.0625));
            }
        }
        return img;
    }
}

