/*
 * Decompiled with CFR 0.152.
 */
package com.ribetec.sdk.image;

import com.ribetec.sdk.image.Filter;
import com.ribetec.sdk.image.Pixel;

public class GrayScale
implements Filter {
    public final int r;
    public final int g;
    public final int b;
    public static final GrayScale DEFAULT = new GrayScale(30, 59, 11);
    public static final GrayScale DARK_GRAY = new GrayScale(50, 50, 50);
    public static final GrayScale MEDIUM_GRAY = new GrayScale(120, 120, 120);
    public static final GrayScale LIGHT_GRAY = new GrayScale(200, 200, 200);

    public GrayScale(int r, int g, int b) {
        this.r = r;
        this.g = g;
        this.b = b;
    }

    public String toString() {
        return "GrayScale(r:" + this.r + " g:" + this.g + " b:" + this.b + ")";
    }

    @Override
    public int pixel(int argb) {
        int bg;
        int gg;
        int a = Pixel.alpha(argb);
        int rg = Pixel.red(argb) * this.r;
        int totalColor = (rg + (gg = Pixel.green(argb) * this.g) + (bg = Pixel.blue(argb) * this.b)) / 100;
        if (totalColor > 255) {
            totalColor = 255;
        } else if (totalColor < 0) {
            totalColor = 0;
        }
        int gray = totalColor;
        return Pixel.toRGB(gray, gray, gray, a);
    }
}

