/*
 * Decompiled with CFR 0.152.
 */
package com.ribetec.sdk.image;

public class Pixel {
    public static final Pixel[] palette = new Pixel[]{new Pixel(0, 0, 0), new Pixel(0, 0, 255), new Pixel(0, 255, 0), new Pixel(0, 255, 255), new Pixel(255, 0, 0), new Pixel(255, 0, 255), new Pixel(255, 255, 0), new Pixel(255, 255, 255)};
    int r;
    int g;
    int b;
    int a;

    public Pixel(int argb) {
        this.a = Pixel.alpha(argb);
        this.r = Pixel.red(argb);
        this.g = Pixel.green(argb);
        this.b = Pixel.blue(argb);
    }

    public Pixel(int r, int g, int b, int a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
    }

    public Pixel(int r, int g, int b) {
        this(r, g, b, 255);
    }

    public Pixel add(Pixel o) {
        return new Pixel(this.r + o.r, this.g + o.g, this.b + o.b, this.a + o.a);
    }

    public int clamp(int c) {
        return Math.max(0, Math.min(255, c));
    }

    public int diff(Pixel o) {
        int Rdiff = o.r - this.r;
        int Gdiff = o.g - this.g;
        int Bdiff = o.b - this.b;
        int Adiff = o.a - this.a;
        int distanceSquared = Rdiff * Rdiff + Gdiff * Gdiff + Bdiff * Bdiff + Adiff * Adiff;
        return distanceSquared;
    }

    public Pixel mul(double d) {
        return new Pixel((int)(d * (double)this.r), (int)(d * (double)this.g), (int)(d * (double)this.b), (int)(d * (double)this.a));
    }

    public Pixel sub(Pixel o) {
        return new Pixel(this.r - o.r, this.g - o.g, this.b - o.b, this.a - o.a);
    }

    public int toRGB() {
        int alpha = this.clamp(this.a);
        int red = this.clamp(this.r);
        int green = this.clamp(this.g);
        int blue = this.clamp(this.b);
        return Pixel.toRGB(red, green, blue, alpha);
    }

    public static Pixel findClosestPaletteColor(Pixel c, Pixel[] palette) {
        Pixel closest = palette[0];
        for (Pixel n : palette) {
            if (n.diff(c) >= closest.diff(c)) continue;
            closest = n;
        }
        return closest;
    }

    public static int alpha(int argb) {
        return argb >> 24 & 0xFF;
    }

    public static int red(int argb) {
        return argb >> 16 & 0xFF;
    }

    public static int green(int argb) {
        return argb >> 8 & 0xFF;
    }

    public static int blue(int argb) {
        return argb & 0xFF;
    }

    public static int toRGB(int r, int g, int b, int a) {
        return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | (b & 0xFF) << 0;
    }

    public static int gray(int argb) {
        int red = argb >> 16 & 0xFF;
        int green = argb >> 8 & 0xFF;
        int blue = argb & 0xFF;
        return red + green + blue / 3;
    }

    public static int toBit(int argb, int threshold) {
        int gray = Pixel.gray(argb);
        return gray < threshold ? 1 : 0;
    }

    public static int toBit(int argb) {
        return Pixel.toBit(argb, 127);
    }

    public static char toBitChar(int argb, int threshold) {
        int gray = Pixel.gray(argb);
        return gray < threshold ? (char)'1' : '0';
    }

    public static char toBitChar(int argb) {
        return Pixel.toBitChar(argb, 127);
    }
}

