/*
 * Decompiled with CFR 0.152.
 */
package com.ribetec.sdk.image;

import com.ribetec.sdk.image.Filter;
import com.ribetec.sdk.image.Pixel;
import com.ribetec.sdk.image.PixelImageAndroid;
import com.ribetec.sdk.image.PixelImageSwing;
import com.ribetec.sdk.image.Transform;
import com.ribetec.sdk.utils.Platform;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public abstract class PixelImage {
    public abstract int getHeight();

    public abstract int getWidth();

    public abstract int getPixel(int var1, int var2);

    public abstract void setPixel(int var1, int var2, int var3);

    public abstract PixelImage newScale(int var1, int var2);

    public int[] getRow(int index) {
        if (index >= this.getHeight()) {
            return null;
        }
        int width = this.getWidth();
        int[] row = new int[width];
        for (int w = 0; w < row.length; ++w) {
            row[w] = this.getPixel(w, index);
        }
        return row;
    }

    public PixelImage newTransform(Transform transform) {
        return transform.apply(this);
    }

    public void apply(Filter filter) {
        int width = this.getWidth();
        int height = this.getHeight();
        for (int row = 0; row < height; ++row) {
            for (int col = 0; col < width; ++col) {
                int pixel = this.getPixel(col, row);
                this.setPixel(col, row, filter.pixel(pixel));
            }
        }
    }

    public static int[][] createPixelMatrixFromImage(PixelImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        int[][] pixelMatrix = new int[height][width];
        for (int row = 0; row < height; ++row) {
            for (int col = 0; col < width; ++col) {
                pixelMatrix[row][col] = image.getPixel(col, row);
            }
        }
        return pixelMatrix;
    }

    public int getHorizontalBytesOfRaster() {
        return this.getWidth() % 8 > 0 ? this.getWidth() / 8 + 1 : this.getWidth() / 8;
    }

    public byte[] getRasterBytes() {
        ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
        for (int y = 0; y < this.getHeight(); ++y) {
            int Byte = 0;
            int bits = 0;
            for (int x = 0; x < this.getWidth(); ++x) {
                int pixel = this.getPixel(x, y);
                int zeroOrOne = Pixel.toBit(pixel);
                Byte |= zeroOrOne << 7 - bits;
                if (++bits != 8) continue;
                byteArray.write(Byte);
                Byte = 0;
                bits = 0;
            }
            if (bits <= 0) continue;
            byteArray.write(Byte);
        }
        return byteArray.toByteArray();
    }

    public static PixelImage of(int[][] pixelMatrix) {
        Platform platform = Platform.get();
        if (platform instanceof Platform.JavaSwing) {
            return new PixelImageSwing(pixelMatrix);
        }
        if (platform instanceof Platform.Android) {
            return new PixelImageAndroid(pixelMatrix);
        }
        throw new RuntimeException("Platform not supported");
    }

    public static PixelImage of(InputStream is) throws IOException {
        Platform platform = Platform.get();
        if (platform instanceof Platform.JavaSwing) {
            return new PixelImageSwing(is);
        }
        if (platform instanceof Platform.Android) {
            return new PixelImageAndroid(is);
        }
        throw new RuntimeException("Platform not supported");
    }

    public static PixelImage of(File path) throws IOException {
        Platform platform = Platform.get();
        if (platform instanceof Platform.JavaSwing) {
            return new PixelImageSwing(path);
        }
        if (platform instanceof Platform.Android) {
            return new PixelImageAndroid(path);
        }
        throw new RuntimeException("Platform not supported");
    }

    public static int getResizedDimension(int maxPrimary, int maxSecondary, int actualPrimary, int actualSecondary) {
        if (maxPrimary == 0 && maxSecondary == 0) {
            return actualPrimary;
        }
        if (maxPrimary == 0) {
            double ratio = (double)maxSecondary / (double)actualSecondary;
            return (int)((double)actualPrimary * ratio);
        }
        if (maxSecondary == 0) {
            return maxPrimary;
        }
        int resized = maxPrimary;
        double ratio = (double)actualSecondary / (double)actualPrimary;
        if ((double)resized * ratio > (double)maxSecondary) {
            resized = (int)((double)maxSecondary / ratio);
        }
        return resized;
    }
}

