/*
 * Decompiled with CFR 0.152.
 */
package com.ribetec.sdk.image;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import com.ribetec.sdk.image.PixelImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class PixelImageAndroid
extends PixelImage {
    public final Bitmap bitmap;

    public PixelImageAndroid(Bitmap b) {
        if (null == b) {
            throw new IllegalArgumentException("bitmap arg cannot be null");
        }
        this.bitmap = b;
    }

    public PixelImageAndroid(File path) throws IOException {
        if (null == path) {
            throw new IllegalArgumentException("image path arg cannot be null");
        }
        this.bitmap = BitmapFactory.decodeFile((String)path.toString());
        if (null == this.bitmap) {
            throw new IOException("unknown image type");
        }
    }

    public PixelImageAndroid(InputStream var1) throws IOException {
        this.bitmap = BitmapFactory.decodeStream((InputStream)var1);
        if (null == this.bitmap) {
            throw new IOException("unknown image type");
        }
    }

    public PixelImageAndroid(int[][] pixelMatrix) {
        int[] row = pixelMatrix[0];
        int width = row.length;
        int height = pixelMatrix.length;
        this.bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        for (int h = 0; h < pixelMatrix.length; ++h) {
            row = pixelMatrix[h];
            for (int w = 0; w < row.length; ++w) {
                int a = row[w];
                this.bitmap.setPixel(w, h, a);
            }
        }
    }

    @Override
    public int getPixel(int x, int y) {
        return this.bitmap.getPixel(x, y);
    }

    @Override
    public void setPixel(int x, int y, int rgb) {
        this.bitmap.setPixel(x, y, rgb);
    }

    @Override
    public int getHeight() {
        return this.bitmap.getHeight();
    }

    @Override
    public int getWidth() {
        return this.bitmap.getWidth();
    }

    @Override
    public PixelImage newScale(int w, int h) {
        if (w > 0 && h > 0) {
            Bitmap b = Bitmap.createScaledBitmap((Bitmap)this.bitmap, (int)w, (int)h, (boolean)true);
            return new PixelImageAndroid(b);
        }
        return this;
    }

    public Bitmap toBinary(Bitmap bmpOriginal) {
        int height = bmpOriginal.getHeight();
        int width = bmpOriginal.getWidth();
        int threshold = 127;
        Bitmap bmpBinary = Bitmap.createBitmap((Bitmap)bmpOriginal);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int pixel = bmpOriginal.getPixel(x, y);
                int red = Color.red((int)pixel);
                if (red < 127) {
                    bmpBinary.setPixel(x, y, -16777216);
                    continue;
                }
                bmpBinary.setPixel(x, y, -1);
            }
        }
        return bmpBinary;
    }
}

