/*
 * Decompiled with CFR 0.152.
 */
package com.ribetec.sdk.image;

import com.ribetec.sdk.image.PixelImage;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

public class PixelImageSwing
extends PixelImage {
    public final BufferedImage image;

    public PixelImageSwing(BufferedImage Image) {
        this.image = Image;
    }

    public PixelImageSwing(File path) throws IOException {
        this(ImageIO.read(path));
    }

    public PixelImageSwing(InputStream is) throws IOException {
        this(ImageIO.read(is));
    }

    public PixelImageSwing(int[][] pixelMatrix) {
        int[] row = pixelMatrix[0];
        int width = row.length;
        int height = pixelMatrix.length;
        this.image = new BufferedImage(width, height, 10);
        for (int h = 0; h < pixelMatrix.length; ++h) {
            row = pixelMatrix[h];
            for (int w = 0; w < row.length; ++w) {
                int a = row[w];
                this.image.setRGB(w, h, a);
            }
        }
    }

    @Override
    public int getPixel(int x, int y) {
        return this.image.getRGB(x, y);
    }

    @Override
    public void setPixel(int x, int y, int rgb) {
        this.image.setRGB(x, y, rgb);
    }

    @Override
    public PixelImage newScale(int w, int h) {
        BufferedImage dbi = new BufferedImage(w, h, this.image.getType());
        Graphics2D graphics2D = dbi.createGraphics();
        graphics2D.drawImage(this.image, 0, 0, w, h, null);
        graphics2D.dispose();
        return new PixelImageSwing(dbi);
    }

    @Override
    public int getHeight() {
        return this.image.getHeight();
    }

    @Override
    public int getWidth() {
        return this.image.getWidth();
    }
}

