/*
 * Decompiled with CFR 0.152.
 */
package com.ribetec.sdk.printer;

import com.ribetec.sdk.printer.PrinterSocket;
import com.ribetec.sdk.utils.IOUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class FilePrinter
extends PrinterSocket {
    boolean isConnected;
    final File file;
    FileOutputStream outputStream;
    FileInputStream inputStream;

    public FilePrinter(File file) {
        this.file = file;
    }

    public FilePrinter(String filename) {
        this(new File(filename));
    }

    @Override
    public void open(long timeout) throws IOException {
        this.outputStream = new FileOutputStream(this.file);
        this.inputStream = new FileInputStream(this.file);
        this.isConnected = true;
    }

    @Override
    public boolean isConnected() throws IOException {
        return this.isConnected;
    }

    @Override
    public void close() {
        IOUtils.closeQuietly(this.outputStream);
        IOUtils.closeQuietly(this.inputStream);
        this.isConnected = false;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public String name() {
        return this.file.toString();
    }

    @Override
    public byte[] read() throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        IOUtils.copy(this.inputStream, bytes);
        return bytes.toByteArray();
    }

    @Override
    public void writeByte(int i) throws IOException {
        this.outputStream.write(i);
    }
}

