/*
 * Decompiled with CFR 0.152.
 */
package com.ribetec.sdk.printer;

import com.ribetec.sdk.printer.PrinterSocket;
import com.ribetec.sdk.utils.IOUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;

public class NetPrinter
extends PrinterSocket {
    public final InetSocketAddress socketAddress;
    private Socket socket;
    private InputStream in;
    private OutputStream out;

    public NetPrinter(String ip) {
        this(ip, 9100);
    }

    public NetPrinter(String ip, int port) {
        this(new InetSocketAddress(ip, port));
    }

    public NetPrinter(InetSocketAddress socketAddress) {
        this.socketAddress = socketAddress;
    }

    @Override
    public void open(long timeout) throws IOException {
        this.socket = new Socket();
        this.socket.connect(this.socketAddress, (int)timeout);
        this.out = this.socket.getOutputStream();
        this.in = this.socket.getInputStream();
    }

    @Override
    public boolean isConnected() {
        return this.socket != null && this.socket.isConnected();
    }

    @Override
    public void close() {
        if (this.socket != null) {
            try {
                IOUtils.closeQuietly(this.out);
                IOUtils.closeQuietly(this.in);
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public String name() {
        return this.socketAddress.getHostName();
    }

    @Override
    public byte[] read() throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        IOUtils.copy(this.in, bytes);
        return bytes.toByteArray();
    }

    @Override
    public void writeByte(int i) throws IOException {
        this.out.write(i);
    }
}

