/*
 * Decompiled with CFR 0.152.
 */
package com.ribetec.sdk.printer;

import com.ribetec.sdk.utils.Utils;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class PrinterSocket
implements Closeable {
    public long openingTimeout = 0L;
    public long closingTimeout = 0L;

    public abstract String name();

    public void open() throws IOException {
        this.open(this.openingTimeout);
    }

    public abstract void open(long var1) throws IOException;

    public abstract boolean isConnected() throws IOException;

    @Override
    public abstract void close();

    public void close(long timeout) {
        PrinterSocket.delay(timeout);
        this.close();
    }

    public abstract byte[] read() throws IOException;

    public abstract void writeByte(int var1) throws IOException;

    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        for (int i = 0; i < len; ++i) {
            this.writeByte(b[off + i]);
        }
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public static void delay(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void exec(byte[] data) throws IOException {
        try {
            this.open(this.openingTimeout);
            this.write(data);
        }
        finally {
            this.close(this.closingTimeout);
        }
    }

    public static void execIn(byte[] data, List<PrinterSocket> sockets) throws IOException {
        if (sockets.size() == 1) {
            sockets.get(0).exec(data);
            return;
        }
        ArrayList<Exception> errors = new ArrayList<Exception>();
        for (int i = 0; i < sockets.size(); ++i) {
            PrinterSocket socket = sockets.get(i);
            try {
                socket.exec(data);
                continue;
            }
            catch (Exception error) {
                errors.add(error);
            }
        }
        if (errors.size() > 0) {
            throw new IOException(Utils.join(errors, "; "));
        }
    }
}

