/*
 * Decompiled with CFR 0.152.
 */
package com.ribetec.sdk.printer.android;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothSocket;
import com.ribetec.sdk.printer.PrinterSocket;
import com.ribetec.sdk.utils.IOUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;

public class AndroidBthPrinter
extends PrinterSocket {
    private static final UUID MY_UUID = UUID.fromString("00001101-0000-1000-8000-00805F9B34FB");
    public final String address;
    private final BluetoothAdapter mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
    private BluetoothSocket socket = null;
    private InputStream in;
    private OutputStream out;

    public AndroidBthPrinter(String address) {
        this.address = address;
    }

    @SuppressLint(value={"MissingPermission"})
    public static BluetoothSocket secureSocket(BluetoothDevice device) throws IOException {
        return device.createRfcommSocketToServiceRecord(MY_UUID);
    }

    @SuppressLint(value={"MissingPermission"})
    public static BluetoothSocket insecureSocket(BluetoothDevice device) throws IOException {
        return device.createInsecureRfcommSocketToServiceRecord(MY_UUID);
    }

    public static BluetoothSocket socket(BluetoothDevice device) throws Exception {
        Class<?> clazz = device.getClass();
        Class[] paramTypes = new Class[]{Integer.TYPE};
        Method m = clazz.getMethod("createRfcommSocket", paramTypes);
        Object[] params = new Object[]{1};
        return (BluetoothSocket)m.invoke((Object)device, params);
    }

    @Override
    @SuppressLint(value={"MissingPermission"})
    public void open(long timeout) throws IOException {
        if (this.mBluetoothAdapter == null) {
            throw new IOException("mBluetoothAdapter == null");
        }
        if (!this.mBluetoothAdapter.isEnabled()) {
            this.mBluetoothAdapter.enable();
            AndroidBthPrinter.delay(timeout / 8L);
            if (!this.mBluetoothAdapter.isEnabled()) {
                throw new IOException("Bluetooth is not enable");
            }
        }
        BluetoothDevice device = this.mBluetoothAdapter.getRemoteDevice(this.address);
        try {
            this.socket = AndroidBthPrinter.secureSocket(device);
            this.mBluetoothAdapter.cancelDiscovery();
            this.socket.connect();
        }
        catch (Exception secureError) {
            try {
                this.socket = AndroidBthPrinter.insecureSocket(device);
                this.mBluetoothAdapter.cancelDiscovery();
                this.socket.connect();
            }
            catch (Exception insecureError) {
                try {
                    this.socket = AndroidBthPrinter.socket(device);
                    Thread.sleep(500L);
                    this.socket.connect();
                }
                catch (Exception socketError) {
                    throw new IOException("Could not connect to '" + this.address + "' device", socketError);
                }
            }
        }
        this.out = this.socket.getOutputStream();
        this.in = this.socket.getInputStream();
    }

    @Override
    public boolean isConnected() {
        return this.socket != null && this.socket.isConnected();
    }

    @Override
    public void close() {
        if (this.socket != null) {
            try {
                IOUtils.closeQuietly(this.out);
                IOUtils.closeQuietly(this.in);
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public String name() {
        return this.address;
    }

    @Override
    public byte[] read() throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        IOUtils.copy(this.in, bytes);
        return bytes.toByteArray();
    }

    @Override
    public void writeByte(int i) throws IOException {
        this.out.write(i);
    }

    @SuppressLint(value={"MissingPermission"})
    public static Set<BluetoothDevice> getBondedDevices() {
        BluetoothAdapter mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (mBluetoothAdapter == null) {
            return new HashSet<BluetoothDevice>();
        }
        return mBluetoothAdapter.getBondedDevices();
    }

    public static BluetoothDevice[] getBondedDevicesAsArray() {
        Set<BluetoothDevice> pairedDevices = AndroidBthPrinter.getBondedDevices();
        return pairedDevices.toArray(new BluetoothDevice[0]);
    }
}

