/*
 * Decompiled with CFR 0.152.
 */
package com.ribetec.sdk.printer.android;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.os.Build;
import java.io.Closeable;
import java.io.IOException;

public class AndroidUsb {
    UsbManager manager;
    UsbDevice device;

    public AndroidUsb(UsbManager manager, UsbDevice device) {
        this.manager = manager;
        this.device = device;
    }

    public Pipe open(int iface, boolean claim) {
        UsbInterface inter = this.device.getInterface(iface);
        Pipe pipe = new Pipe(this);
        pipe.iface = inter;
        pipe.outEndpoint = inter.getEndpoint(0);
        pipe.inEndpoint = inter.getEndpoint(1);
        if (claim) {
            if (pipe.isDetach()) {
                pipe.detach();
            }
            pipe.claimInterface();
        }
        return pipe;
    }

    public Pipe open(int iface) {
        return this.open(iface, true);
    }

    public Pipe open() {
        return this.open(0);
    }

    public static class Pipe
    implements Closeable {
        final AndroidUsb usb;
        final UsbDeviceConnection conn;
        UsbInterface iface;
        UsbEndpoint outEndpoint;
        UsbEndpoint inEndpoint;
        public int timeout;

        public Pipe(AndroidUsb usb) {
            this.usb = usb;
            this.conn = usb.manager.openDevice(usb.device);
        }

        public boolean isDetach() {
            return false;
        }

        public void detach() {
        }

        public void claimInterface() {
            this.conn.claimInterface(this.iface, true);
        }

        public void releaseInterface(UsbInterface inter) {
            this.conn.releaseInterface(inter);
        }

        @Override
        public void close() {
            if (this.iface != null) {
                this.releaseInterface(this.iface);
            }
            this.conn.close();
        }

        public int write(byte[] bytes, int off, int len) throws IOException {
            if (Build.VERSION.SDK_INT >= 18) {
                return this.conn.bulkTransfer(this.outEndpoint, bytes, off, len, this.timeout);
            }
            throw new IOException("Unsupported API level. Minimum required: Jelly Bean MR2 (API 18)");
        }

        public int write(byte[] bytes) throws IOException {
            return this.write(bytes, 0, bytes.length);
        }
    }
}

