/*
 * Decompiled with CFR 0.152.
 */
package com.ribetec.sdk.printer.android;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbManager;
import android.os.Build;
import com.ribetec.sdk.printer.PrinterSocket;
import com.ribetec.sdk.printer.android.AndroidUsb;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class AndroidUsbPrinter
extends PrinterSocket {
    private static final String ACTION_USB_PERMISSION = "tprinter.printer.android.USB_PERMISSION";
    private static UsbManager usbManagerCache;
    public final Context context;
    public final UsbDevice device;
    AndroidUsb.Pipe mPipe;

    public AndroidUsbPrinter(Context context, int vid, int pid) {
        this.context = context;
        this.device = AndroidUsbPrinter.deviceOrAny(context, vid, pid);
    }

    public AndroidUsbPrinter(Context context, String vid, String pid) {
        this(context, Integer.parseInt(vid), Integer.parseInt(pid));
    }

    public AndroidUsbPrinter(Context context, String path) {
        this.context = context;
        this.device = AndroidUsbPrinter.deviceOrAny(context, path);
    }

    public static UsbManager usbManager(Context context) {
        if (usbManagerCache == null) {
            usbManagerCache = (UsbManager)context.getSystemService("usb");
        }
        return usbManagerCache;
    }

    public static HashMap<String, UsbDevice> devices(Context context) {
        return AndroidUsbPrinter.usbManager(context).getDeviceList();
    }

    public static UsbDevice device(Context context, int vid, int pid) {
        Collection<UsbDevice> connectedDevices = AndroidUsbPrinter.devices(context).values();
        for (UsbDevice device : connectedDevices) {
            if (device.getVendorId() != vid || device.getProductId() != pid) continue;
            return device;
        }
        return null;
    }

    public static UsbDevice deviceOrAny(Context context, String path) {
        UsbDevice device = null;
        HashMap<String, UsbDevice> connectedDevices = AndroidUsbPrinter.devices(context);
        for (Map.Entry<String, UsbDevice> entry : connectedDevices.entrySet()) {
            String key = entry.getKey();
            device = entry.getValue();
            if (!key.equals(path)) continue;
            return device;
        }
        return device;
    }

    public static UsbDevice deviceOrAny(Context context, int vid, int pid) {
        UsbDevice device = null;
        HashMap<String, UsbDevice> connectedDevices = AndroidUsbPrinter.devices(context);
        for (Map.Entry<String, UsbDevice> entry : connectedDevices.entrySet()) {
            device = entry.getValue();
            if (device.getVendorId() != vid || device.getProductId() != pid) continue;
            return device;
        }
        return device;
    }

    public static PendingIntent permissionIntent(Context context) {
        if (Build.VERSION.SDK_INT >= 23) {
            return PendingIntent.getBroadcast((Context)context, (int)0, (Intent)new Intent(ACTION_USB_PERMISSION), (int)0x4000000);
        }
        return PendingIntent.getBroadcast((Context)context, (int)0, (Intent)new Intent(ACTION_USB_PERMISSION), (int)0);
    }

    @Override
    public String name() {
        return this.device == null ? null : this.device.getDeviceName();
    }

    @Override
    public void open(long i) throws IOException {
        if (this.device == null) {
            throw new RuntimeException("No USB device detected");
        }
        UsbManager usbManager = AndroidUsbPrinter.usbManager(this.context);
        if (!usbManager.hasPermission(this.device)) {
            PendingIntent mPermissionIntent = AndroidUsbPrinter.permissionIntent(this.context);
            int count = 0;
            while (!usbManager.hasPermission(this.device)) {
                usbManager.requestPermission(this.device, mPermissionIntent);
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++count;
            }
        }
        AndroidUsb musb = new AndroidUsb(usbManager, this.device);
        AndroidUsb.Pipe pipe = musb.open();
        pipe.timeout = 2000;
        this.mPipe = pipe;
    }

    @Override
    public boolean isConnected() throws IOException {
        return this.mPipe != null;
    }

    @Override
    public void close() {
        if (this.mPipe != null) {
            this.mPipe.close();
            this.mPipe = null;
        }
    }

    @Override
    public byte[] read() throws IOException {
        return new byte[0];
    }

    @Override
    public void writeByte(int b) throws IOException {
        this.mPipe.write(new byte[]{(byte)b});
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.mPipe.write(b, off, len);
    }
}

