/*
 * Decompiled with CFR 0.152.
 */
package com.ribetec.sdk.printer.desktop;

import com.ribetec.sdk.printer.PrinterSocket;
import com.ribetec.sdk.printer.desktop.internal.CupsUtils;
import com.ribetec.sdk.printer.desktop.internal.ShellUtils;
import com.ribetec.sdk.printer.desktop.internal.WinUtils;
import com.ribetec.sdk.utils.IOUtils;
import com.ribetec.sdk.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.print.Doc;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.HashAttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.PrinterInfo;
import javax.print.attribute.standard.PrinterName;
import javax.print.attribute.standard.PrinterResolution;
import javax.print.event.PrintJobEvent;
import javax.print.event.PrintJobListener;
import javax.swing.JComboBox;
import tprinter.printer.internal.FlushOutputStream;

public class DriverPrinter
extends PrinterSocket {
    public final String printerId;
    private PrintService printerService;
    private String printerName;
    private String printerInfo;
    private PrinterResolution printerResolution;
    private String printerDriver;
    private String printerConnection;
    private String printerManufacturer;
    protected DocPrintJob mJob;
    protected FlushOutputStream out;
    public PrintProcessor printProcessor = PrintProcessor.PRINT_RAW;

    public DriverPrinter(Object printerId) {
        if (printerId == null) {
            throw new RuntimeException("printername == null");
        }
        this.printerId = printerId.toString();
    }

    public DriverPrinter(PrintService printService) {
        this(printService.getName());
        this.setPrinterService(this.printerService);
    }

    public void load(PrintService printService) {
        PrinterInfo pi;
        if (printService == null) {
            return;
        }
        PrintServiceAttributeSet attrs = this.printerService.getAttributes();
        PrinterName pn = (PrinterName)attrs.get(PrinterName.class);
        if (pn != null) {
            this.setPrinterName(pn.getValue());
        }
        if ((pi = (PrinterInfo)attrs.get(PrinterInfo.class)) != null) {
            this.setPrinterInfo(pi.getValue());
        }
        PrinterResolution pr = (PrinterResolution)this.printerService.getDefaultAttributeValue(PrinterResolution.class);
        this.setPrinterResolution(pr);
        if (WinUtils.isWindows()) {
            WinUtils.fillAttributes(this);
        } else {
            CupsUtils.fillAttributes(this);
        }
    }

    public PrintService getPrinterService() {
        if (this.printerService == null) {
            this.printerService = DriverPrinter.findPrintService(this.printerId);
            this.setPrinterService(this.printerService);
        }
        return this.printerService;
    }

    public void setPrinterService(PrintService printerService) {
        this.printerService = printerService;
        this.load(printerService);
    }

    public String getPrinterName() {
        this.getPrinterService();
        return this.printerName;
    }

    public void setPrinterName(String printerName) {
        this.printerName = printerName;
    }

    public String getPrinterInfo() {
        this.getPrinterService();
        return this.printerInfo;
    }

    public void setPrinterInfo(String printerInfo) {
        this.printerInfo = printerInfo;
    }

    public PrinterResolution getPrinterResolution() {
        this.getPrinterService();
        return this.printerResolution;
    }

    public void setPrinterResolution(PrinterResolution printerResolution) {
        this.printerResolution = printerResolution;
    }

    public String getPrinterDriver() {
        this.getPrinterService();
        return this.printerDriver;
    }

    public void setPrinterDriver(String printerDriver) {
        this.printerDriver = printerDriver;
    }

    public String getPrinterConnection() {
        this.getPrinterService();
        return this.printerConnection;
    }

    public void setPrinterConnection(String printerConnection) {
        this.printerConnection = printerConnection;
    }

    public String getPrinterManufacturer() {
        this.getPrinterService();
        return this.printerManufacturer;
    }

    public void setPrinterManufacturer(String printerManufacturer) {
        this.printerManufacturer = printerManufacturer;
    }

    public Media[] getSupportedMedia() {
        return (Media[])this.getPrinterService().getSupportedAttributeValues(Media.class, null, null);
    }

    public String destination() {
        String printername = this.getPrinterName();
        return !Utils.isEmpty(printername) ? printername : this.printerId;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Id: ").append(this.printerId).append("\n");
        sb.append("Name: ").append(this.getPrinterName()).append("\n");
        sb.append("Driver: ").append(this.getPrinterDriver()).append("\n");
        PrinterResolution resolution = this.getPrinterResolution();
        if (resolution != null) {
            sb.append("Density: ").append(resolution.getFeedResolution(100)).append("dpi\n");
        }
        sb.append("Connection: ").append(this.getPrinterConnection()).append("\n");
        sb.append("Manufacturer: ").append(this.getPrinterManufacturer()).append("\n");
        return sb.toString();
    }

    @Override
    public void open(long i) throws IOException {
        this.close();
        PrintService printService = this.getPrinterService();
        if (printService == null) {
            throw new IOException("not found " + this.printerId);
        }
        this.mJob = printService.createPrintJob();
        this.out = new FlushOutputStream(){

            @Override
            public void writeTo(byte[] toByteArray) throws IOException {
                DriverPrinter.this.doPrint(DriverPrinter.this.mJob, toByteArray);
            }
        };
    }

    @Override
    public boolean isConnected() throws IOException {
        return this.mJob != null;
    }

    @Override
    public void close(long timeout) {
        this.close();
        DriverPrinter.delay(timeout);
    }

    @Override
    public void close() {
        IOUtils.closeQuietly(this.out);
        this.mJob = null;
    }

    @Override
    public String name() {
        return this.printerId;
    }

    public void doPrint(DocPrintJob job, byte[] data) throws IOException {
        switch (this.printProcessor) {
            case PRINT_DIRECT: {
                this.printDirect(job, new ByteArrayInputStream(data));
                break;
            }
            case PRINT_ALT_CUPS: {
                this.printAltCups(job, data);
                break;
            }
            default: {
                this.printRaw(job, data);
            }
        }
    }

    public void printRaw(DocPrintJob job, byte[] data) throws IOException {
        try {
            SimpleDoc doc = new SimpleDoc(data, DocFlavor.BYTE_ARRAY.AUTOSENSE, null);
            HashPrintRequestAttributeSet attrs = new HashPrintRequestAttributeSet();
            attrs.add(new JobName("Thermal-Printer Raw Print", Locale.getDefault()));
            this.waitForPrint(job, doc, attrs);
        }
        catch (PrintException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public void printDirect(DocPrintJob job, InputStream data) throws IOException {
        try {
            SimpleDoc doc = new SimpleDoc(data, DocFlavor.INPUT_STREAM.AUTOSENSE, null);
            HashPrintRequestAttributeSet attrs = new HashPrintRequestAttributeSet();
            attrs.add(new JobName("Thermal-Printer Direct Print", Locale.getDefault()));
            this.waitForPrint(job, doc, attrs);
        }
        catch (PrintException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    protected void waitForPrint(DocPrintJob job, Doc doc, PrintRequestAttributeSet attrs) throws PrintException {
        final AtomicBoolean var4 = new AtomicBoolean(false);
        job.addPrintJobListener(new PrintJobListener(){

            @Override
            public void printDataTransferCompleted(PrintJobEvent var1) {
                var4.set(true);
            }

            @Override
            public void printJobCompleted(PrintJobEvent var1) {
                var4.set(true);
            }

            @Override
            public void printJobFailed(PrintJobEvent var1) {
                var4.set(true);
            }

            @Override
            public void printJobCanceled(PrintJobEvent var1) {
                var4.set(true);
            }

            @Override
            public void printJobNoMoreEvents(PrintJobEvent var1) {
                var4.set(true);
            }

            @Override
            public void printJobRequiresAttention(PrintJobEvent var1) {
                var4.set(true);
            }
        });
        job.print(doc, attrs);
        while (!var4.get()) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printAltCups(DocPrintJob job, byte[] data) throws IOException {
        File tmp = File.createTempFile("thermal_printer_raw_", ".prn");
        try {
            IOUtils.writeByteArray(tmp, data);
            Object[] cmd = new String[]{"lpr", "-P", this.destination(), "-o", "raw", tmp.getAbsolutePath()};
            boolean r = ShellUtils.execute((String[])cmd);
            if (!r) {
                throw new IOException("Printing failed: " + Arrays.toString(cmd));
            }
        }
        finally {
            if (!tmp.delete()) {
                tmp.deleteOnExit();
            }
        }
    }

    @Override
    public byte[] read() throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void writeByte(int i) throws IOException {
        this.out.write(i);
    }

    public static DriverPrinter[] printers() {
        PrintService[] services = DriverPrinter.services();
        int len = services.length;
        DriverPrinter[] printers = new DriverPrinter[len];
        for (int i = 0; i < len; ++i) {
            printers[i] = new DriverPrinter(services[i]);
        }
        return printers;
    }

    public static PrintService[] services() {
        PrintService[] services = PrintServiceLookup.lookupPrintServices(null, null);
        Utils.reverse(services);
        return services;
    }

    public static PrintService findPrintService(String printerName) {
        PrintService[] pservices;
        for (PrintService printService : pservices = DriverPrinter.services()) {
            if (!printService.getName().equals(printerName)) continue;
            return printService;
        }
        return DriverPrinter.findPrintServiceAset(printerName);
    }

    public static PrintService findPrintServiceAset(String printerName) {
        PrintService[] pservices;
        HashAttributeSet aset = new HashAttributeSet();
        aset.add(new PrinterName(printerName, null));
        for (PrintService printService : pservices = PrintServiceLookup.lookupPrintServices(null, aset)) {
            if (!printService.getName().equals(printerName)) continue;
            return printService;
        }
        return null;
    }

    public static void fill(JComboBox comboBox) {
        PrintService[] services = DriverPrinter.services();
        PrintService defaultService = PrintServiceLookup.lookupDefaultPrintService();
        comboBox.removeAllItems();
        for (int i = 0; i < services.length; ++i) {
            comboBox.addItem(services[i].getName());
            if (!services[i].equals(defaultService)) continue;
            comboBox.setSelectedIndex(i);
        }
    }

    public static enum PrintProcessor {
        PRINT_RAW,
        PRINT_DIRECT,
        PRINT_ALT_CUPS;

    }
}

