/*
 * Decompiled with CFR 0.152.
 */
package com.ribetec.sdk.printer.desktop.internal;

import com.ribetec.sdk.printer.desktop.DriverPrinter;
import com.ribetec.sdk.printer.desktop.internal.ShellUtils;
import java.util.HashMap;
import java.util.Map;

public class CupsUtils {
    public static String findAttribute(String raw, String search, String first, String end) {
        String sQuery = search + first;
        int i = raw.indexOf(sQuery);
        if (i != -1) {
            String result = raw.substring(i);
            int iEnd = result.indexOf(end);
            if (iEnd > 0) {
                return result.substring(result.indexOf(first) + first.length(), iEnd);
            }
            return result.substring(result.indexOf(first) + first.length());
        }
        return null;
    }

    public static String findAttribute(String raw, String search) {
        return CupsUtils.findAttribute(raw, search, "=", " ");
    }

    public static Map<String, StringBuilder> lpstat() {
        HashMap<String, StringBuilder> r = new HashMap<String, StringBuilder>();
        String lpstat = "\r\n" + ShellUtils.executeRaw("lpstat", "-l", "-p");
        String[] split = lpstat.split("[\\r\\n]printer ");
        for (int a = 0; a < split.length; ++a) {
            String data = split[a];
            if (data.trim().isEmpty()) continue;
            String key = null;
            StringBuilder value = null;
            String[] lines = data.split("\\r?\\n");
            for (int b = 0; b < lines.length; ++b) {
                String line = lines[b].trim();
                if (key == null) {
                    key = line.split("\\s+")[0];
                    value = new StringBuilder();
                    r.put(key, value);
                    continue;
                }
                value.append(line);
                value.append(";");
            }
        }
        return r;
    }

    public static String lpstat(String printerName) {
        Map<String, StringBuilder> r = CupsUtils.lpstat();
        for (Map.Entry<String, StringBuilder> entry : r.entrySet()) {
            String key = entry.getKey();
            StringBuilder value = entry.getValue();
            if (!key.equals(printerName)) continue;
            return value.toString();
        }
        return "";
    }

    public static void fillAttributes(DriverPrinter printer) {
        String lpoptions = ShellUtils.executeRaw("lpoptions", "-p", printer.getPrinterName());
        String connection = CupsUtils.findAttribute(lpoptions, "device-uri");
        printer.setPrinterConnection(connection);
        String manufacturer = CupsUtils.findAttribute(lpoptions, "printer-make-and-model");
        printer.setPrinterManufacturer(manufacturer);
        String lpstat = CupsUtils.lpstat(printer.getPrinterName());
        String driver = CupsUtils.findAttribute(lpstat, "Interface", ": ", ";");
        printer.setPrinterDriver(driver);
        if (driver == null || driver.isEmpty()) {
            printer.setPrinterDriver("TEXTONLY.ppd");
        }
    }
}

