/*
 * Decompiled with CFR 0.152.
 */
package com.ribetec.sdk.printer.desktop.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringJoiner;

public final class ShellUtils {
    private ShellUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readLines(InputStream input, boolean close) throws IOException {
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(input));
            StringJoiner result = new StringJoiner(System.getProperty("line.separator"));
            while ((line = reader.readLine()) != null) {
                result.add(line);
            }
            String string = result.toString();
            return string;
        }
        finally {
            if (close) {
                input.close();
            }
        }
    }

    public static String readLines(Process process, boolean close) throws IOException {
        String output = ShellUtils.readLines(process.getInputStream(), close);
        if (output != null) {
            return output;
        }
        String error = ShellUtils.readLines(process.getErrorStream(), close);
        if (error != null) {
            return error;
        }
        return "";
    }

    public static String executeRaw(String ... args) {
        Runtime runtime = Runtime.getRuntime();
        try {
            Process process = runtime.exec(args);
            return ShellUtils.readLines(process, true);
        }
        catch (IOException e) {
            e.printStackTrace(System.out);
            return "";
        }
    }

    public static boolean execute(String ... args) {
        Runtime runtime = Runtime.getRuntime();
        try {
            Process process = runtime.exec(args);
            while (process.getInputStream().read() != -1) {
            }
            process.waitFor();
            return process.exitValue() == 0;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
    }
}

