/*
 * Decompiled with CFR 0.152.
 */
package com.ribetec.sdk.printer.desktop.internal;

import com.ribetec.sdk.printer.desktop.DriverPrinter;
import com.ribetec.sdk.printer.desktop.internal.WinReg;
import java.util.Locale;

public final class WinUtils {
    private WinUtils() {
    }

    public static String readRegString(int hkey, String key, String valueName) {
        try {
            return WinReg.readString(hkey, key, valueName);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return null;
        }
    }

    public static boolean isWindows() {
        String os = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
        return os.contains("win");
    }

    public static void fillAttributes(DriverPrinter driverPrinter) {
        String guid;
        String printer = driverPrinter.printerId;
        String key = "SYSTEM\\CurrentControlSet\\Control\\Print\\Printers\\" + printer;
        String driver = WinUtils.readRegString(-2147483646, key, "Printer Driver");
        String port = WinUtils.readRegString(-2147483646, key, "Port");
        String manufacturer = WinUtils.readRegString(-2147483646, key + "\\PnPData", "Manufacturer");
        if (driver == null && (guid = WinUtils.readRegString(-2147483647, key = "Printers\\Connections\\" + printer, "GuidPrinter")) != null) {
            String var7 = printer.replaceAll(",,(.+),.+", "$1");
            key = "Software\\Microsoft\\Windows NT\\CurrentVersion\\Print\\Providers\\Client Side Rendering Print Provider\\Servers\\" + var7 + "\\Printers\\" + guid;
            driver = WinUtils.readRegString(-2147483646, key, "Printer Driver");
            port = WinUtils.readRegString(-2147483646, key + "\\DsSpooler", "portName");
        }
        driverPrinter.setPrinterDriver(driver);
        driverPrinter.setPrinterConnection(port);
        driverPrinter.setPrinterManufacturer(manufacturer);
    }

    public static void main(String[] args) throws Exception {
        System.out.println(WinReg.readString(-2147483646, "SYSTEM\\CurrentControlSet\\Control\\Print\\Printers\\4BARCODE 4B-2033PA (Copiar 1)\\PnPData", "Manufacturer"));
    }
}

