/*
 * Decompiled with CFR 0.152.
 */
package com.ribetec.sdk.tspl;

import com.ribetec.sdk.printer.PrinterSocket;
import com.ribetec.sdk.utils.IOUtils;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TSPL
extends DataOutputStream {
    public TSPL(OutputStream output) {
        super(output);
    }

    public void setSize(String width, String height) throws IOException {
        this.writeLine("SIZE " + width + ", " + height);
    }

    public void setSize(float width, float height, Units units) throws IOException {
        if (units == Units.MM) {
            this.setSize(width + " mm", height + " mm");
        } else if (units == Units.INCH) {
            this.setSize(width + "", height + "");
        }
    }

    public void setSpeed(int speed) throws IOException {
        this.writeLine("SPEED " + speed);
    }

    public void setDensity(int density) throws IOException {
        this.writeLine("DENSITY " + density);
    }

    public void setGap(float m, float n, boolean sensor, Units units) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(sensor ? "BLINE " : "GAP ");
        if (units == Units.MM) {
            sb.append(m).append(" mm, ").append(n).append(" mm");
        } else if (units == Units.INCH) {
            sb.append(m).append(", ").append(n).append("");
        }
        this.writeLine(sb.toString());
    }

    public void setGap(float m, float n, Units units) throws IOException {
        this.setGap(m, n, false, units);
    }

    public void setContinuous() throws IOException {
        this.setGap(0.0f, 0.0f, Units.MM);
    }

    public void setRibbon(Ribbon ribbon) throws IOException {
        this.writeLine(ribbon.value);
    }

    public void setDirection(int n, int m) throws IOException {
        this.writeLine("DIRECTION " + n + "," + m);
    }

    public void setReference(int x, int y) throws IOException {
        this.writeLine("REFERENCE " + x + "," + y);
    }

    public void setOffset(float m) throws IOException {
        this.writeLine("OFFSET " + m + " mm");
    }

    public void setCodepage(String n) throws IOException {
        this.writeLine("CODEPAGE " + n);
    }

    public void text(int x, int y, String font, Rotation rotation, int x_multiplication, int y_multiplication, String string) throws IOException {
        String text = "TEXT ";
        String position = x + ", " + y;
        String size_value = "\"" + TSPL.escape(font) + "\"";
        String rota = "" + rotation.value;
        String x_value = "" + x_multiplication;
        String y_value = "" + y_multiplication;
        String string_value = "\"" + TSPL.escape(string) + "\"";
        String message = text + position + ", " + size_value + ", " + rota + ", " + x_value + ", " + y_value + ", " + string_value;
        this.writeLine(message);
    }

    public void bar(int x, int y, int width, int height) throws IOException {
        this.writeLine("BAR " + x + ", " + y + ", " + width + ", " + height);
    }

    public void barcode(int x, int y, BarcodeType type, int height, BarcodeTxt human_readable, Rotation rotation, int narrow, int wide, String string) throws IOException {
        String barcode = "BARCODE ";
        String position = x + "," + y;
        String mode = "\"" + type.value + "\"";
        String height_value = "" + height;
        String human_value = "" + human_readable.value;
        String rota = "" + rotation.value;
        String narrow_value = "" + narrow;
        String wide_value = "" + wide;
        String string_value = "\"" + string + "\"";
        String message = barcode + position + " ," + mode + " ," + height_value + " ," + human_value + " ," + rota + " ," + narrow_value + " ," + wide_value + " ," + string_value;
        this.writeLine(message);
    }

    public void qrcode(int x, int y, QRErrorCorrectionLevel ECC_level, int cell_width, QRMode mode, Rotation rotation, QRCodeModel model, QRCodeMask mask, String content) throws IOException {
        this.writeLine("QRCODE " + x + ", " + y + ", " + ECC_level.value + ", " + cell_width + ", " + mode.value + ", " + rotation.value + ", " + model.value + ", " + mask.value + ", \"" + TSPL.escape(content) + "\"");
    }

    public void qrcode(int x, int y, QRErrorCorrectionLevel ECC_level, int cell_width, Rotation rotation, QRCodeModel model, String content) throws IOException {
        this.qrcode(x, y, ECC_level, cell_width, QRMode.AUTO, rotation, model, QRCodeMask.S7, content);
    }

    public void qrcode(int x, int y, int cell_width, Rotation rotation, String data) throws IOException {
        this.qrcode(x, y, QRErrorCorrectionLevel.M, cell_width, rotation, QRCodeModel._2, data);
    }

    public void qrcode(int x, int y, Rotation rotation, String data) throws IOException {
        this.qrcode(x, y, 4, rotation, data);
    }

    public void downloadfile(String filename, File file) throws IOException {
        this.writeBytes("DOWNLOAD F,\"" + filename + "\"," + file.length() + ",");
        this.write(IOUtils.readByteArray(file));
        this.writeBytes("\r\n");
        PrinterSocket.delay(100L);
    }

    public void downloadfile(String filename, byte[] data) throws IOException {
        this.writeBytes("DOWNLOAD F,\"" + filename + "\"," + data.length + ",");
        this.write(data);
        this.writeBytes("\r\n");
        PrinterSocket.delay(100L);
    }

    public void downloadfile(String filename, InputStream stream) throws IOException {
        try {
            this.writeBytes("DOWNLOAD F,\"" + filename + "\"," + stream.available() + ",");
            this.write(IOUtils.readByteArray(stream));
            this.writeBytes("\r\n");
            PrinterSocket.delay(100L);
        }
        finally {
            stream.close();
        }
    }

    public void putbmp(int x, int y, String filename) throws IOException {
        this.writeLine("PUTBMP " + x + ", " + y + ", \"" + filename + "\"");
    }

    public void copys(int quantity, int copy) throws IOException {
        this.writeLine("PRINT " + quantity + ", " + copy);
    }

    public void formfeed() throws IOException {
        this.writeLine("FORMFEED");
    }

    public void nobackfeed() throws IOException {
        this.writeLine("SET TEAR OFF");
    }

    public void cls() throws IOException {
        this.writeLine("CLS");
    }

    public static String escape(String str) {
        return str.replace("\"", "\\[\"]");
    }

    public void writeLine(String cmd) throws IOException {
        this.writeBytes(cmd + "\r\n");
    }

    public void restart() throws IOException {
        byte[] message = new byte[]{27, 33, 82};
        this.write(message);
    }

    public static enum QRCodeMask {
        S0("S0"),
        S1("S1"),
        S2("S2"),
        S3("S3"),
        S4("S4"),
        S5("S5"),
        S6("S6"),
        S7("S7"),
        S8("S8");

        public String value;

        private QRCodeMask(String b) {
            this.value = b;
        }
    }

    public static enum QRCodeModel {
        _1("M1"),
        _2("M2");

        public String value;

        private QRCodeModel(String b) {
            this.value = b;
        }
    }

    public static enum QRMode {
        AUTO("A"),
        MANUAL("M");

        public final String value;

        private QRMode(String value) {
            this.value = value;
        }
    }

    public static enum QRErrorCorrectionLevel {
        H("H"),
        Q("Q"),
        M("M"),
        L("L");

        public final String value;

        private QRErrorCorrectionLevel(String value) {
            this.value = value;
        }
    }

    public static enum BarcodeTxt {
        OFF(0),
        LEFT(1),
        CENTER(2),
        RIGHT(3);

        public byte value;

        private BarcodeTxt(int b) {
            this.value = (byte)b;
        }
    }

    public static enum BarcodeType {
        _128("128"),
        _128M("128M"),
        _EAN128("EAN128"),
        _EAN128M("EAN128M"),
        _25("25"),
        _25C("25C"),
        _25S("25S"),
        _25I("25I"),
        _39("39"),
        _39C("39C"),
        _39S("39S"),
        _EAN13("EAN13"),
        _EAN13_2("EAN13+2"),
        _EAN13_5("EAN13+5"),
        _EAN8("EAN8"),
        _EAN8_2("EAN8+2"),
        _EAN8_5("EAN8+5"),
        _CODA("CODA"),
        _POST("POST"),
        _UPCA("UPCA"),
        _UPCA_2("UPCA+2"),
        _UPCA_5("UPCA+5"),
        _UPCE("UPCE"),
        _UPCE_2("UPCE+2"),
        _UPCE_5("UPCE+5"),
        _CPOST("CPOST"),
        _MSI("MSI"),
        _MSIC("MSIC"),
        _PLESSEY("PLESSEY"),
        _ITF14("ITF14"),
        _EAN14("EAN14"),
        _11("11"),
        _TELEPEN("TELEPEN"),
        _TELEPENN("TELEPENN"),
        _PLANET("PLANET"),
        _CODE49("CODE49"),
        _DPI("DPI"),
        _DPL("DPL");

        public String value;

        private BarcodeType(String value) {
            this.value = value;
        }
    }

    public static enum Rotation {
        _0(0),
        _90(90),
        _180(180),
        _270(270);

        public int value;

        private Rotation(int value) {
            this.value = value;
        }
    }

    public static enum Ribbon {
        ON("SET RIBBON ON"),
        OFF("SET RIBBON OFF"),
        INSIDE("SET RIBBON INSIDE"),
        OUTSIDE("SET RIBBON OUTSIDE");

        public String value;

        private Ribbon(String value) {
            this.value = value;
        }
    }

    public static enum Units {
        INCH,
        MM;

    }
}

