/*
 * Decompiled with CFR 0.152.
 */
package com.ribetec.sdk.utils;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class IOUtils {
    public static void closeQuietly(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void copy(InputStream from, OutputStream out) throws IOException {
        int count;
        if (from == null) {
            throw new IOException("source == null");
        }
        byte[] buffer = new byte[1024];
        while ((count = from.read(buffer)) != -1) {
            out.write(buffer, 0, count);
        }
    }

    public static void writeByteArray(File file, byte[] data) throws IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file, false);
            ((OutputStream)out).write(data, 0, data.length);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly(out);
    }

    public static byte[] readByteArray(File file) throws IOException {
        byte[] byArray;
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            byArray = IOUtils.readByteArray(in);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly(in);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readByteArray(InputStream in) throws IOException {
        if (in == null) {
            throw new IOException("source == null");
        }
        byte[] buffer = new byte[1024];
        try (ByteArrayOutputStream bytes = new ByteArrayOutputStream(in.available());){
            int count;
            while ((count = in.read(buffer)) != -1) {
                bytes.write(buffer, 0, count);
            }
            byte[] byArray = bytes.toByteArray();
            return byArray;
        }
    }
}

