/*
 * Decompiled with CFR 0.152.
 */
package com.ribetec.sdk.utils;

import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import java.util.concurrent.Executor;
import javax.swing.SwingUtilities;

public class Platform
implements Executor {
    private static final Platform PLATFORM = Platform.findPlatform();

    public static Platform get() {
        return PLATFORM;
    }

    private static Platform findPlatform() {
        try {
            Class.forName("android.os.Build");
            if (Build.VERSION.SDK_INT != 0) {
                return new Android();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            Class.forName("javax.swing.SwingUtilities");
            return new JavaSwing();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return new Platform();
        }
    }

    @Override
    public void execute(Runnable command) {
        command.run();
    }

    public static class JavaSwing
    extends Platform {
        @Override
        public void execute(Runnable command) {
            SwingUtilities.invokeLater(command);
        }
    }

    public static class Android
    extends Platform {
        final Handler mHandler = new Handler(Looper.getMainLooper());

        @Override
        public void execute(Runnable command) {
            this.mHandler.post(command);
        }
    }
}

