/*
 * Decompiled with CFR 0.152.
 */
package com.ribetec.sdk.zpl;

import com.ribetec.sdk.printer.PrinterSocket;
import com.ribetec.sdk.zpl.ZplGraphics;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;

public class Zpl
extends DataOutputStream {
    private static final HashMap<Integer, String> CACHE_ASCII_HEX = new HashMap();
    private int _x = 0;
    private int _y = 0;
    public boolean autoFormatHex = true;

    public Zpl(OutputStream output) {
        super(output);
    }

    private void newLine() throws IOException {
        this.write("\r\n".getBytes());
    }

    public void writeLine(String cmd) throws IOException {
        this.write(cmd.getBytes("UTF-8"));
        this.newLine();
    }

    public void start() throws IOException {
        this.writeLine("^XA");
    }

    public void end() throws IOException {
        this.writeLine("^XZ");
        this.newLine();
    }

    public void setHeightDots(int len) throws IOException {
        this.writeLine("^LL" + len);
    }

    public void setWidthDots(int len) throws IOException {
        this.writeLine("^PW" + len);
    }

    public void setSize(int widthDots, int heightDots) throws IOException {
        this.setWidthDots(widthDots);
        this.setHeightDots(heightDots);
    }

    public void setSizeMM(float width, float height, int dpi) throws IOException {
        int widthDots = (int)((float)dpi * (width / 25.4f));
        int heightDots = (int)((float)dpi * (height / 25.4f));
        this.setSize(widthDots, heightDots);
    }

    public void setSizeMM(float width, float height) throws IOException {
        this.setSizeMM(width, height, 203);
    }

    public void setOperationMode(OperationMode mode) throws IOException {
        this.writeLine("^MM" + mode.desiredMode + mode.prePeelSelect);
    }

    public void printImageOfLabelOff() throws IOException {
        this.writeLine("^PMN");
    }

    public void printImageOfLabelOn() throws IOException {
        this.writeLine("^PMY");
    }

    public void setLabelHome(int x, int y) throws IOException {
        this.writeLine("^LH" + x + "," + y);
    }

    public void setLabeTop(int x) throws IOException {
        this.writeLine("^LT" + x);
    }

    public void setLabeShift(int x) throws IOException {
        this.writeLine("^LS" + x);
    }

    public void setPrintOrientation(PrintOrientation po) throws IOException {
        this.writeLine("^PO" + po.value);
    }

    public void _rotation(Rotation rotation) throws IOException {
        this.writeLine("^AD" + rotation.value);
    }

    public void setTrackingMode(TrackingMode mode, Integer dots) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("^MN").append(mode.value);
        if (dots != null && mode != TrackingMode.CONTINUOUS) {
            sb.append(",").append(dots);
        }
        this.writeLine(sb.toString());
    }

    public void setTrackingMode(TrackingMode mode) throws IOException {
        this.setTrackingMode(mode, null);
    }

    public void setGap(int dots) throws IOException {
        this.setTrackingMode(TrackingMode.NO_CONTINUOUS, dots);
    }

    public void setGapMM(float m, int dpi) throws IOException {
        this.setGap((int)((float)dpi * (m / 25.4f)));
    }

    public void setGapMM(float m) throws IOException {
        this.setGapMM(m, 203);
    }

    public void setContinuous() throws IOException {
        this.setTrackingMode(TrackingMode.CONTINUOUS);
    }

    public void font(Font font, int size) throws IOException {
        this.writeLine("^CF" + font.value + "," + size);
    }

    public void font(Font font, int h, int w) throws IOException {
        this.writeLine("^CF" + font.value + "," + h + "," + w);
    }

    public void text(int x, int y, Font font, int fontH, int fontW, String str, Justification justification) throws IOException {
        this.writeLine("^FO" + this.x(x) + "," + this.y(y) + "," + justification.value);
        this.writeLine("^A" + font.value + "N," + fontH + "," + fontW);
        this.writeLine(this._fd(str));
    }

    public void text(int x, int y, Font font, int fontH, int fontW, String str) throws IOException {
        this.writeLine("^FO" + this.x(x) + "," + this.y(y));
        this.writeLine("^A" + font.value + "N," + fontH + "," + fontW);
        this.writeLine(this._fd(str));
    }

    public void text(int x, int y, String str) throws IOException {
        this.writeLine("^FO" + this.x(x) + "," + this.y(y));
        this.writeLine(this._fd(str));
    }

    public void text(int x, int y, Font font, int fontSize, String str) throws IOException {
        this.font(font, fontSize);
        this.text(x, y, str);
    }

    public void textBlock(int x, int y, Font font, int fontH, int fontW, String str, int width, int numLines, Alignment textJustification) throws IOException {
        this.writeLine("^FO" + this.x(x) + "," + this.y(y));
        this.writeLine("^A" + font.value + "N," + fontH + "," + fontW);
        this.writeLine("^FB" + width + "," + numLines + ",1," + textJustification.value + ",0");
        this.writeLine(this._fd(str));
    }

    public void barcodeFieldDefault(int w, float r, int h) throws IOException {
        this.writeLine("^BY" + w + "," + r + "," + h);
    }

    public void barcode39(int x, int y, int moduleWidth, int wideBarRatio, int barCodeHeigth, String data) throws IOException {
        this.writeLine("^FO" + this.x(x) + "," + this.y(y));
        this.writeLine("^BY" + moduleWidth + "," + wideBarRatio + "," + barCodeHeigth);
        this.writeLine("^BC");
        this.writeLine(this._fd(data));
    }

    public void barcode128(int x, int y, int heigth, BarcodeTxt barcodeTxt, Rotation rotation, int width, String data) throws IOException {
        this.writeLine("^FO" + this.x(x) + "," + this.y(y));
        this.writeLine("^BY" + width);
        this.writeLine("^BC" + rotation.value + "," + heigth + "," + barcodeTxt.value + ",N,N");
        this.writeLine(this._fd(data));
    }

    public void qrcode(int x, int y, QRCodeModel model, int size, QRErrorCorrectionLevel ecl, String data, String characterMode) throws IOException {
        this.writeLine("^FO" + this.x(x) + "," + this.y(y) + "^BQN," + model.value + "," + size);
        if (this.autoFormatHex) {
            this.writeLine("^FH\\^FD" + ecl.value + characterMode + "," + this.formatField(data) + "^FS");
        } else {
            this.writeLine("^FD" + ecl.value + characterMode + "," + data + "^FS");
        }
    }

    public void qrcode(int x, int y, QRCodeModel model, int size, QRErrorCorrectionLevel ecl, String data) throws IOException {
        this.qrcode(x, y, model, size, ecl, data, "A");
    }

    public void qrcode(int x, int y, String data) throws IOException {
        this.qrcode(x, y, QRCodeModel._2, y, QRErrorCorrectionLevel.M, data);
    }

    public static String asciiToHex(int ascii) {
        String hex = CACHE_ASCII_HEX.get(ascii);
        if (hex == null) {
            hex = String.format("%02X", ascii);
            CACHE_ASCII_HEX.put(ascii, hex);
        }
        return hex;
    }

    public String formatField(CharSequence str) {
        StringBuilder sb = new StringBuilder(str.length());
        for (int i = 0; i < str.length(); ++i) {
            char character = str.charAt(i);
            char ascii = character;
            if (Character.isLetter((int)ascii) || Character.isDigit((int)ascii) || ascii == ' ') {
                sb.append(character);
                continue;
            }
            sb.append('\\').append(Zpl.asciiToHex(ascii));
        }
        return sb.toString();
    }

    private String _fd(String data) {
        if (this.autoFormatHex) {
            return "^FH\\^FD" + this.formatField(data) + "^FS";
        }
        return "^FD" + data + "^FS";
    }

    public void rectangle(int x, int y, int w, int h, int line) throws IOException {
        this.writeLine("^FO" + this.x(x) + "," + this.y(y));
        this.writeLine("^GB" + w + "," + h + "," + line + "^FS");
    }

    public void bar(int x, int y, int w, int line) throws IOException {
        this.rectangle(x, y, w, 1, line);
    }

    public void image(ZplGraphics graphics) throws IOException {
        String zpl = graphics.getZplCode(true);
        this.write(zpl.getBytes());
        PrinterSocket.delay(100L);
    }

    public void copys(int cantidad) throws IOException {
        this.writeLine("^PQ" + cantidad + ",0,1,Y");
    }

    public void setSumX(int x) {
        this._x = x;
    }

    public void setSumY(int y) {
        this._y = y;
    }

    protected int x(int val) {
        return this._x + val;
    }

    protected int y(int val) {
        return this._y + val;
    }

    public void utf8() throws IOException {
        this.writeLine("^CI28");
    }

    public static String cleanParam(String str) {
        String trim = str == null ? "" : str.trim();
        return trim.replace(" ", "").replace("\n", "").replace("\r", "");
    }

    public static String crlf(String str) {
        return str.replace("\r", "").replace("\n", "\r\n");
    }

    public static String[] paramsOf(String command, int limit) {
        String[] r = new String[limit];
        int index = 0;
        int aux = 0;
        for (int i = 0; i < command.length(); ++i) {
            char c = command.charAt(i);
            if (c != ',' && i != command.length() - 1) continue;
            if (index < limit - 1) {
                r[index] = command.substring(aux, i);
                aux = i + 1;
                ++index;
                continue;
            }
            r[index] = command.substring(aux);
            break;
        }
        return r;
    }

    public static enum QRErrorCorrectionLevel {
        H("H"),
        Q("Q"),
        M("M"),
        L("L");

        public final String value;

        private QRErrorCorrectionLevel(String value) {
            this.value = value;
        }
    }

    public static enum QRCodeModel {
        _1(49),
        _2(50);

        public byte value;

        private QRCodeModel(int b) {
            this.value = (byte)b;
        }
    }

    public static enum BarcodeTxt {
        NOT("N"),
        YES("Y");

        public String value;

        private BarcodeTxt(String b) {
            this.value = b;
        }
    }

    public static enum PrintOrientation {
        NORMAL("N"),
        INVERT("I");

        public final String value;

        private PrintOrientation(String value) {
            this.value = value;
        }
    }

    public static enum TrackingMode {
        CONTINUOUS("N"),
        NO_CONTINUOUS("Y"),
        WEB_SENSING("W"),
        MARK_SENSING("M");

        public final String value;

        private TrackingMode(String value) {
            this.value = value;
        }
    }

    public static enum OperationMode {
        TEAR_OFF("T"),
        REWIND("R"),
        PEEL_OFF_SELECT("P", true),
        PEEL_OFF_NOSELECT("P", false),
        CUTTER("C");

        public final String desiredMode;
        public final String prePeelSelect;

        private OperationMode(String desiredMode) {
            this.desiredMode = desiredMode;
            this.prePeelSelect = "";
        }

        private OperationMode(String desiredMode, boolean prePeelSelectB) {
            this.desiredMode = desiredMode;
            this.prePeelSelect = prePeelSelectB ? ",Y" : ",N";
        }
    }

    public static enum PPP {
        DPI_203(8.0f),
        DPI_300(12.0f),
        DPI_600(23.5f);

        public float dotByMm;

        private PPP(float dotByMm) {
            this.dotByMm = dotByMm;
        }
    }

    public static enum Justification {
        LEFT(0),
        RIGHT(1),
        AUTO(2);

        public final int value;

        private Justification(int val) {
            this.value = val;
        }
    }

    public static enum Alignment {
        LEFT("L"),
        CENTER("C"),
        RIGHT("R"),
        JUSTIFIED("J");

        public final String value;

        private Alignment(String val) {
            this.value = val;
        }
    }

    public static enum Rotation {
        NORMAL("N"),
        ROTATE_90("R"),
        INVERTED("I"),
        READ_FROM_BOTTOM("B");

        public final String value;

        private Rotation(String val) {
            this.value = val;
        }
    }

    public static enum Font {
        ZERO("0"),
        A("A"),
        B("B"),
        C("C"),
        D("D"),
        F("F"),
        G("G");

        public final String value;

        private Font(String value) {
            this.value = value;
        }
    }
}

