/*
 * Decompiled with CFR 0.152.
 */
package com.ribetec.sdk.zpl;

import com.ribetec.sdk.image.PixelImage;
import com.ribetec.sdk.zpl.CompressedBitmapOutputStreamZpl;
import com.ribetec.sdk.zpl.ZplGraphics;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ZplDitheredGraphics
extends ZplGraphics {
    public ZplDitheredGraphics(PixelImage image) {
        super(image);
    }

    @Override
    public void writeTo(OutputStream out, boolean insideFormat) throws IOException {
        int lenrow = (this.pixels.getWidth() + 7) / 8;
        int len = lenrow * this.pixels.getHeight();
        String header = this.getBodyHeader(insideFormat, lenrow, len);
        out.write(header.getBytes());
        this.printBody(out);
        if (!insideFormat) {
            out.write("^XZ".getBytes());
        }
    }

    public void printBody(OutputStream out) throws IOException {
        CompressedBitmapOutputStreamZpl compressed = new CompressedBitmapOutputStreamZpl(out);
        ZplDitheredGraphics.getDitheredImage(this.pixels, compressed);
        compressed.flush();
    }

    @Override
    public String getZplCode(boolean insideFormat) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(this.pixels.getWidth() * this.pixels.getHeight());
        this.writeTo(out, insideFormat);
        return new String(out.toByteArray());
    }

    public static void getDitheredImage(PixelImage image, OutputStream out) throws IOException {
        ZplDitheredGraphics.getDitheredImage(image.getWidth(), image.getHeight(), image, out);
    }

    protected static void getDitheredImage(int width, int height, PixelImage image, OutputStream out) throws IOException {
        int i;
        int[] row1 = image.getRow(0);
        int[] row2 = image.getRow(1);
        int widthBytes = width / 8 + (width % 8 == 0 ? 0 : 1);
        int var7 = 8 - width % 8;
        if (var7 == 8) {
            var7 = 0;
        }
        byte[] buffer = new byte[widthBytes];
        int bit = 0;
        for (i = 0; i < width; ++i) {
            row1[i] = ZplDitheredGraphics.convertByteToGrayscale(row1[i]);
        }
        for (i = 0; i < height; ++i) {
            int indexBuf;
            for (indexBuf = 0; indexBuf < buffer.length; ++indexBuf) {
                buffer[indexBuf] = 0;
            }
            indexBuf = 0;
            for (int w = 0; w < width; ++w) {
                if (w % 8 == 0) {
                    bit = -128;
                }
                int bRow1 = row1[w];
                indexBuf = w / 8;
                int bitBW = bRow1 >= 128 ? -1 : 0;
                buffer[indexBuf] = (byte)(buffer[indexBuf] | bit & bitBW);
                int bitBW2 = bRow1 - (bitBW & 0xFF);
                if (w < width - 1) {
                    int n = w + 1;
                    row1[n] = row1[n] + 7 * bitBW2 / 16;
                }
                if (w > 0 && i < height - 1) {
                    int n = w - 1;
                    row2[n] = row2[n] + 3 * bitBW2 / 16;
                }
                if (i < height - 1) {
                    if (w == 0) {
                        row2[w] = ZplDitheredGraphics.convertByteToGrayscale(row2[w]);
                    }
                    int n = w;
                    row2[n] = row2[n] + 5 * bitBW2 / 16;
                }
                if (i < height - 1 && w < width - 1) {
                    row2[w + 1] = ZplDitheredGraphics.convertByteToGrayscale(row2[w + 1]);
                    int n = w + 1;
                    row2[n] = row2[n] + bitBW2 / 16;
                }
                bit = (byte)((bit & 0xFF) >>> 1);
            }
            buffer[indexBuf] = (byte)(buffer[indexBuf] | 255 >>> 8 - var7);
            out.write(buffer);
            row1 = row2;
            row2 = image.getRow(i + 2);
        }
    }

    public static int convertByteToGrayscale(int var0) {
        int r = (var0 & 0xFF0000) >>> 16;
        int g = (var0 & 0xFF00) >>> 8;
        int b = var0 & 0xFF;
        int totalColor = (r * 30 + g * 59 + b * 11) / 100;
        if (totalColor > 255) {
            totalColor = 255;
        } else if (totalColor < 0) {
            totalColor = 0;
        }
        return totalColor;
    }

    public PixelImage image() {
        return this.pixels;
    }
}

