/*
 * Decompiled with CFR 0.152.
 */
package com.ribetec.sdk.zpl;

import com.ribetec.sdk.image.PixelImage;
import java.io.IOException;
import java.io.OutputStream;

public abstract class ZplGraphics {
    public final PixelImage pixels;
    protected Integer x;
    protected Integer y;

    public ZplGraphics(PixelImage pixels) {
        this.pixels = pixels;
    }

    public void setPoint(Integer x, Integer y) {
        this.x = x;
        this.y = y;
    }

    public String getBodyHeader(boolean insideFormat, int bytesPerRow, int binaryByteCount) {
        StringBuilder result = new StringBuilder();
        if (!insideFormat) {
            result.append("^XA");
        }
        if (this.x != null && this.y != null) {
            result.append("^FO").append(this.x).append(",").append(this.y);
        }
        result.append("^GFA").append(",");
        result.append(binaryByteCount).append(",");
        result.append(binaryByteCount).append(",");
        result.append(bytesPerRow).append(",");
        return result.toString();
    }

    public void writeTo(OutputStream out, boolean insideFormat) throws IOException {
        String zpl = this.getZplCode(insideFormat);
        for (int i = 0; i < zpl.length(); ++i) {
            out.write(zpl.charAt(i));
        }
    }

    public abstract String getZplCode(boolean var1) throws IOException;
}

