/*
 * Decompiled with CFR 0.152.
 */
package com.ribetec.sdk.zpl;

public class ZplHexCompressed {
    private static final int[] intVal = new int[]{380, 360, 340, 320, 300, 280, 260, 240, 220, 200, 180, 160, 140, 120, 100, 80, 60, 40, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1};
    private static final char[] charVal = new char[]{'y', 'x', 'w', 'v', 'u', 't', 's', 'r', 'q', 'p', 'o', 'n', 'm', 'l', 'k', 'j', 'i', 'h', 'g', 'Y', 'X', 'W', 'V', 'U', 'T', 'S', 'R', 'Q', 'P', 'O', 'N', 'M', 'L', 'K', 'J', 'I', 'H', 'G'};

    public static int intVal(char ascii) {
        for (int i = 0; i < charVal.length; ++i) {
            if (charVal[i] != ascii) continue;
            return intVal[i];
        }
        return 0;
    }

    public static char charVal(int charMap) {
        for (int i = 0; i < intVal.length; ++i) {
            if (intVal[i] != charMap) continue;
            return charVal[i];
        }
        return '\u0000';
    }

    public static String compress(int widthBytes, String rasterBytesHex) {
        StringBuilder sb = new StringBuilder();
        int maxlinea = widthBytes * 2;
        StringBuilder sbLinea = new StringBuilder();
        String previousLine = null;
        int counter = 1;
        char aux = rasterBytesHex.charAt(0);
        boolean firstChar = false;
        for (int i = 1; i < rasterBytesHex.length(); ++i) {
            int resto20;
            if (firstChar) {
                aux = rasterBytesHex.charAt(i);
                firstChar = false;
                continue;
            }
            if (rasterBytesHex.charAt(i) == '\n') {
                if (counter >= maxlinea && aux == '0') {
                    sbLinea.append(",");
                } else if (counter >= maxlinea && aux == 'F') {
                    sbLinea.append("!");
                } else if (counter > 20) {
                    int multi20 = counter / 20 * 20;
                    sbLinea.append(ZplHexCompressed.charVal(multi20));
                    resto20 = counter % 20;
                    if (resto20 != 0) {
                        sbLinea.append(ZplHexCompressed.charVal(resto20));
                    }
                    sbLinea.append(aux);
                } else {
                    sbLinea.append(ZplHexCompressed.charVal(counter)).append(aux);
                }
                counter = 1;
                firstChar = true;
                String linea = sbLinea.toString();
                if (linea.equals(previousLine)) {
                    sb.append(":");
                } else {
                    sb.append(linea);
                }
                previousLine = linea;
                sbLinea.setLength(0);
                continue;
            }
            if (aux == rasterBytesHex.charAt(i)) {
                ++counter;
                continue;
            }
            if (counter > 20) {
                int multi20 = counter / 20 * 20;
                sbLinea.append(ZplHexCompressed.charVal(multi20));
                resto20 = counter % 20;
                if (resto20 != 0) {
                    sbLinea.append(ZplHexCompressed.charVal(resto20));
                }
                sbLinea.append(aux);
            } else {
                sbLinea.append(ZplHexCompressed.charVal(counter)).append(aux);
            }
            counter = 1;
            aux = rasterBytesHex.charAt(i);
        }
        return sb.toString();
    }

    public static CharSequence unCompress(int widthBytes, String hexRasterBytesCompress) {
        StringBuilder out = new StringBuilder();
        int maxlinea = widthBytes * 2;
        StringBuilder sbLine = new StringBuilder(maxlinea);
        String previousLine = null;
        boolean writeLine = false;
        int auxMapCodeAscii = 0;
        for (int i = 0; i < hexRasterBytesCompress.length(); ++i) {
            char c = hexRasterBytesCompress.charAt(i);
            int mapCodeAscii = ZplHexCompressed.intVal(c);
            if (mapCodeAscii > 0) {
                auxMapCodeAscii += mapCodeAscii;
                continue;
            }
            if (c == ',') {
                for (int r = sbLine.length(); r < maxlinea; ++r) {
                    sbLine.append('0');
                }
                writeLine = true;
            } else if (c == '!') {
                for (int r = sbLine.length(); r < maxlinea; ++r) {
                    sbLine.append('F');
                }
                writeLine = true;
            } else if (c == ':') {
                out.append(previousLine).append('\n');
            } else {
                if (auxMapCodeAscii == 0) {
                    auxMapCodeAscii = 1;
                }
                for (int repitHex = 1; repitHex <= auxMapCodeAscii; ++repitHex) {
                    sbLine.append(c);
                    if (sbLine.length() < maxlinea) continue;
                    String linea = sbLine.toString();
                    sbLine.setLength(0);
                    out.append(linea).append('\n');
                    previousLine = linea;
                }
            }
            if (writeLine) {
                String linea = sbLine.toString();
                sbLine.setLength(0);
                out.append(linea).append('\n');
                previousLine = linea;
                writeLine = false;
            }
            auxMapCodeAscii = 0;
        }
        return out;
    }
}

