/*
 * Decompiled with CFR 0.152.
 */
package com.ribetec.sdk.zpl;

import com.ribetec.sdk.image.Pixel;
import com.ribetec.sdk.image.PixelImage;
import com.ribetec.sdk.zpl.ZplGraphics;
import com.ribetec.sdk.zpl.ZplHexCompressed;
import java.io.IOException;
import java.math.BigInteger;

public class ZplHexGraphics
extends ZplGraphics {
    private boolean compressHex = true;

    public ZplHexGraphics(PixelImage image) {
        super(image);
    }

    @Override
    public String getZplCode(boolean insideFormat) throws IOException {
        int width = this.pixels.getWidth();
        int height = this.pixels.getHeight();
        int widthBytes = width / 8 + (width % 8 == 0 ? 0 : 1);
        int total = widthBytes * height;
        StringBuilder zpl = new StringBuilder();
        zpl.append(this.getBodyHeader(insideFormat, widthBytes, total));
        String rasterBytesHex = this.getRasterBytesHex(width, height);
        if (this.compressHex) {
            rasterBytesHex = ZplHexCompressed.compress(widthBytes, rasterBytesHex);
        }
        zpl.append(rasterBytesHex);
        if (!insideFormat) {
            zpl.append("^XZ");
        }
        return zpl.toString();
    }

    public String getRasterBytesHex(int width, int height) {
        StringBuilder rasterBytesHex = new StringBuilder();
        char[] bitsArray = new char[]{'0', '0', '0', '0', '0', '0', '0', '0'};
        int numBits = 0;
        for (int h = 0; h < height; ++h) {
            for (int w = 0; w < width; ++w) {
                char zeroOrOne;
                int pixel = this.pixels.getPixel(w, h);
                bitsArray[numBits] = zeroOrOne = Pixel.toBitChar(pixel);
                if (++numBits != 8 && w != width - 1) continue;
                String Byte = new String(bitsArray);
                rasterBytesHex.append(ZplHexGraphics.bitsToHex(Byte));
                for (int i = 0; i < bitsArray.length; ++i) {
                    bitsArray[i] = 48;
                }
                numBits = 0;
            }
            rasterBytesHex.append("\n");
        }
        return rasterBytesHex.toString();
    }

    public static String bitsToHex(String Byte) {
        int decimal = Integer.parseInt(Byte, 2);
        if (decimal > 15) {
            return Integer.toString(decimal, 16).toUpperCase();
        }
        return "0" + Integer.toString(decimal, 16).toUpperCase();
    }

    public ZplHexGraphics setCompressHex(boolean compressHex) {
        this.compressHex = compressHex;
        return this;
    }

    public static CharSequence rasterBytesHexToBinary(CharSequence rasterBytesHex) {
        StringBuilder binary = new StringBuilder();
        for (int i = 0; i < rasterBytesHex.length(); ++i) {
            char c = rasterBytesHex.charAt(i);
            if (c == '\n') {
                binary.append(c);
                continue;
            }
            binary.append(ZplHexGraphics.hexToBinary(String.valueOf(c), 4));
        }
        return binary;
    }

    private static String hexToBinary(String hex, int cols) {
        String binary = new BigInteger(hex, 16).toString(2);
        int len = binary.length();
        if (len < cols) {
            int dif = cols - binary.length();
            StringBuilder r = new StringBuilder(len + dif);
            for (int i = 0; i < dif; ++i) {
                r.append(0);
            }
            r.append(binary);
            return r.toString();
        }
        return binary;
    }
}

