/*
 * Decompiled with CFR 0.152.
 */
package com.ribetec.sdk.zpl;

import com.ribetec.sdk.image.PixelImage;
import com.ribetec.sdk.utils.Base64;
import com.ribetec.sdk.utils.IOUtils;
import com.ribetec.sdk.zpl.ZplGraphics;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.DeflaterOutputStream;

public class ZplLibGraphics
extends ZplGraphics {
    public ZplLibGraphics(PixelImage image) {
        super(image);
    }

    public static String getCRCHexString(String bytes) {
        int crc = 0;
        int polynomial = 4129;
        for (int c = 0; c < bytes.length(); ++c) {
            byte b = (byte)bytes.charAt(c);
            for (int i = 0; i < 8; ++i) {
                boolean bit = (b >> 7 - i & 1) == 1;
                boolean c15 = (crc >> 15 & 1) == 1;
                crc <<= 1;
                if (!(c15 ^ bit)) continue;
                crc ^= 0x1021;
            }
        }
        return Integer.toHexString(crc &= 0xFFFF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] deflate(byte[] data) throws IOException {
        byte[] byArray;
        DeflaterOutputStream deflaterOutputStream = null;
        try {
            ByteArrayOutputStream compressedImage = new ByteArrayOutputStream(data.length);
            deflaterOutputStream = new DeflaterOutputStream(compressedImage);
            deflaterOutputStream.write(data, 0, data.length);
            deflaterOutputStream.finish();
            byArray = compressedImage.toByteArray();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(deflaterOutputStream);
            throw throwable;
        }
        IOUtils.closeQuietly(deflaterOutputStream);
        return byArray;
    }

    @Override
    public String getZplCode(boolean insideFormat) throws IOException {
        int width = this.pixels.getWidth();
        int height = this.pixels.getHeight();
        byte[] rasterBytes = this.pixels.getRasterBytes();
        byte[] deflate = this.deflate(rasterBytes);
        String z64 = Base64.getEncoder().encodeToString(deflate);
        String crcString = ZplLibGraphics.getCRCHexString(z64);
        int bytesPerRow = rasterBytes.length / height;
        int binaryByteCount = width * height / 8;
        StringBuilder zpl = new StringBuilder();
        zpl.append(this.getBodyHeader(insideFormat, bytesPerRow, binaryByteCount));
        zpl.append(":Z64:");
        zpl.append(z64);
        zpl.append(":");
        zpl.append(crcString);
        if (!insideFormat) {
            zpl.append("^XZ");
        }
        return zpl.toString();
    }
}

